/**
 * Gestion d'un encodeur rotatif avec bouton reset
 * 
 * @author mrcjl <mjl1@morceau.fr>
 * @version 1.1 (05/2018)
 * @copyright CC0 1.0 Universal
 */
 
#include <Arduino.h>
#include "myEncodeur.h"

myEncodeur::myEncodeur(int CLK, int DT) {
  // Définition des broches d'entrées
  pin_clk = CLK;  
  pin_dt = DT; 

   // Initialisation des broches d'entrées...
   pinMode (pin_clk,INPUT);
   pinMode (pin_dt,INPUT);
    
   // ...et activation de leurs résistances de PULL-UP
   digitalWrite(pin_clk, true);
   digitalWrite(pin_dt, true);

   // Lecture initiale de Pin_CLK
   Pin_clk_Letzter = digitalRead(pin_clk); 
   Changed = false; 
} 

// Le programme vérifie si un changement des états des broches a eu lieu, 
// et selon la broche qui est modifiée en premier, détermine le sens de rotation.
// Cette information est obtenue par la comparaison des signaux présents sur les 2 sorties.
// Une fois que la direction a été déterminée, on compte les mouvements depuis la position
// de départ et on les envoie vers la sortie série.
 
void myEncodeur::update() { 
   // Lecture des statuts actuels
   Pin_clk_Aktuell = digitalRead(pin_clk);
    
   // Vérification de changement
   if (Pin_clk_Aktuell != Pin_clk_Letzter)
   { 
          
        if (digitalRead(pin_dt) != Pin_clk_Aktuell) 
        {  
            // Pin_CLK a changé en premier
            Compteur ++;
            Direction = true;
        } 
          
        else
        {       // Sinon Pin_DT achangé en premier
            Direction = false;
            Compteur--;
        }
        // Préparation de la prochaine exécution:
        Pin_clk_Letzter = Pin_clk_Aktuell;

        Changed = true;
   }
}

boolean myEncodeur::isRotate() {
        bool t = Changed;
        Changed = false;
        return t;
}

boolean myEncodeur::getSens() {
        if (Direction) return true;
        else return false;
}
        
int myEncodeur::getValue() {
        return Compteur;
} 

void myEncodeur::setValue(int x) {
  Compteur = x;
}
 
