
    // This project is protected under the Attribution-NonCommercial-ShareAlike 3.0 Unported (CC BY-NC-SA 3.0)
    // Attribute this initial work to  https://github.com/pchretien/fibo  (Horloge de Fibonacci)
    //
    // Adaptation par <jean-louis.morceau@club-internet.fr> 
    //    * Version piloté par port USB
    
    
    // Gestion du DS1307 circuit RTC connecté via I2C
    #include <Wire.h>
    #include "RTClib.h"
    RTC_DS1307 RTC;
    int hour = 0;
    int minute = 0;
    byte oldHours = 0;
    byte oldMinutes = 0;
    
    // Gestion du ruban de Leds
    #include <Adafruit_NeoPixel.h>
    #define LED_PIN 2             // Pin du ruban
    #define LED_COUNT 12          // Nombre de leds utilisées. Les répartir dans "setPixel()"
    #define DEBOUNCE_DELAY 10
    #define TOTAL_PALETTES 10     // Nombre de palettes disponibles
    #define TOTAL_LIGHTLEVEL 10   // Nombre de niveau d'intensité lumineuse
    #define MAX_MODES 1
    Adafruit_NeoPixel leds = Adafruit_NeoPixel(LED_COUNT, LED_PIN, NEO_GRB + NEO_KHZ800);
    uint32_t black = leds.Color(0,0,0);
    uint8_t lightLevels[TOTAL_LIGHTLEVEL] = {0, 2, 4, 8, 16, 32, 64, 128, 192, 255};
    int lightLevelIndex = 3;      // Niveau de luminosité
    int palette = 0;              //Palette du ruban de Leds
    uint32_t colors[TOTAL_PALETTES][4] = {
      {
        // #1 RGB
        leds.Color(255,255,255),    // off
        leds.Color(255,10,10),  // hours
        leds.Color(10,255,10),  // minutes
        leds.Color(10,10,255) // both;
      }, 
      {
        // #2 Mondrian
        leds.Color(255,255,255),    // off
        leds.Color(255,10,10),  // hours
        leds.Color(248,222,0),  // minutes
        leds.Color(10,10,255) // both;
      }, 
      {
        // #3 Basbrun
        leds.Color(255,255,255),    // off
        leds.Color(80,40,0),  // hours
        leds.Color(20,200,20),  // minutes
        leds.Color(255,100,10) // both;
      },
      {
        // #4 80's
        leds.Color(255,255,255),    // off
        leds.Color(245,100,201),  // hours
        leds.Color(114,247,54),  // minutes
        leds.Color(113,235,219) // both;
      },
      {
        // #5 Pastel
        leds.Color(255,255,255),    // off
        leds.Color(255,123,123),  // hours
        leds.Color(143,255,112),  // minutes
        leds.Color(120,120,255) // both;
      },
      {
        // #6 Modern
        leds.Color(255,255,255),    // off
        leds.Color(212,49,45),  // hours
        leds.Color(145,210,49),  // minutes
        leds.Color(141,95,224) // both;
      },
      {
        // #7 Cold
        leds.Color(255,255,255),    // off
        leds.Color(209,62,200),  // hours
        leds.Color(69,232,224),  // minutes
        leds.Color(80,70,202) // both;
      },
      {
        // #8 Warm
        leds.Color(255,255,255),    // off
        leds.Color(237,20,20),  // hours
        leds.Color(246,243,54),  // minutes
        leds.Color(255,126,21) // both;
      },
      {
        //#9 Earth
        leds.Color(255,255,255),    // off
        leds.Color(70,35,0),  // hours
        leds.Color(70,122,10),  // minutes
        leds.Color(200,182,0) // both;
      },
      {
        // #10 Dark
        leds.Color(255,255,255),    // off
        leds.Color(211,34,34),  // hours
        leds.Color(80,151,78),  // minutes
        leds.Color(16,24,149) // both;
      }
    };
    String namePalette[TOTAL_PALETTES] = {
     "01 RGB", "02 Mondrian", "03 Basbrun", "04 80's", "05 Pastel", "06 Modern", "07 Cold", "08 Warm", "09 Earth", "10 Dark"
    };
    
    // Variables pour calcul de l'heure Fibomacci
    #define CLOCK_PIXELS 5 
    byte bits[CLOCK_PIXELS];
    int ledsValues[CLOCK_PIXELS] = {1,1,2,3,5};

    // Variables pour les réglages
    int mode = 0;     //mode d'affichage
    int timer = 0;    //timer pour l'affichage
    int cx;           //commande reçue

    /**
     * Initialistion à la mise sous tension
     */
    void setup () {
        // Initialisation liaison série
        Serial.begin(9600);
        Serial.println();
        Serial.println("\nInitialisation horloge !");
        
        // Initialisation du module RTC
        Wire.begin();
        RTC.begin();
        if (! RTC.isrunning()) {
          Serial.println("RTC arrete ! Reinitialisation !");
          // following line sets the RTC to the date & time this sketch was compiled
          RTC.adjust(DateTime(__DATE__, __TIME__));
        }

        // Initialisation du ruban de Leds
        leds.begin();
        leds.setBrightness(lightLevels[lightLevelIndex]);
        leds.show();

        // Initialisation du dialogue
        Serial.println ("Pour dialoguer, envoyer : xyy.");
        Serial.println ("x = commande [Annee, Omois, Jour, Heure, Minute, Luminosité, Palette]");
        Serial.println ("yy = valeur à 2 chiffes");
    }

    /**
     * Boucle principale
     */
    void loop () {
        // Récupération et affichage de l'heure
        DateTime now = RTC.now();
        //printDate (now);
        dispTime (now.hour(), now.minute());

        // Lecture des commandes
        if (Serial.available() >= 3)
          getCmd ();

        // Temporisation (limitation à 4 boucles par seconde)
        //delay (15000);
    }

    /**
     * Affiche la date et heure sur la liaison série
     * @param now DateTime valeur du moment
     */
    void printDate(DateTime now) {
        Serial.print(now.year(), DEC);
        Serial.print('/');
        Serial.print(now.month(), DEC);
        Serial.print('/');
        Serial.print(now.day(), DEC);
        Serial.print(' ');
        Serial.print(now.hour(), DEC);
        Serial.print(':');
        Serial.print(now.minute(), DEC);
        Serial.print(':');
        Serial.print(now.second(), DEC);
        Serial.println();
        Serial.println();
    }
    
    /**
     * Affiche l'heure sur les leds
     * @param hours int Heures
     * @param minutes int minutes
     */
    void dispTime(int hours, int minutes) {
      byte hoursInstr[CLOCK_PIXELS];
      byte minsInstr[CLOCK_PIXELS];
      
      if(hours >= 12) calcInstructionTwo(hours % 12, hoursInstr);
      else calcInstructionTwo(hours, hoursInstr);
      calcInstructionOne(minutes / 5, minsInstr);
      
      for(int i=0; i<CLOCK_PIXELS; i++)
        bits[i] = (hoursInstr[i] * 0x01) | (minsInstr[i] * 0x02);

      affTimeLED ();
    }

    /**
     * Calcul de la séquence de Fibonacci METHODE 1
     * @param time int Valeur à convertir
     * @param instr array(int) Séquence résultat
     */
    void calcInstructionOne(int time, byte instr[]) {
      int remain[] = {0, 1, 2, 4, 7 };
      for (int i=4; i >= 0; i--) {
        if (time > remain[i] ) {
          time -= ledsValues[i];
          instr[i] = 1;
        } else {
          instr[i] = 0;
        }
        //instr[time%5] = 1;
      }
    }
    
    /**
     * Calcul de la séquence de Fibonacci METHODE 2
     * @param time int Valeur à convertir
     * @param instr array(int) Séquence résultat
     */
    void calcInstructionTwo(int time, byte instr[]) {
      for( int i = 4; i >= 0; i--) {
         if(time >= ledsValues[i]) {
           time -= ledsValues[i];
           instr[i] = 1;
         } else {
           instr[i] = 0;
         }
      }
    }

    /**
     * Affichage sur LEDs RGB
     */
     void affTimeLED () {
      int j = CLOCK_PIXELS;
      for(int i=0; i<j; i++)
        setPixel(i, colors[palette][bits[i]]);
      leds.show();
    }
    
    void setPixel(byte pixel, uint32_t color) {
      switch(pixel) {
        case 0:
          leds.setPixelColor(0, color);
          break;
        case 1:
          leds.setPixelColor(1, color);
          break;
        case 2:
          leds.setPixelColor(2, color);
          leds.setPixelColor(3, color);
          break;
        case 3:
          leds.setPixelColor(4, color);
          leds.setPixelColor(5, color);
          leds.setPixelColor(6, color);
          break;
        case 4:
          leds.setPixelColor(7, color);
          leds.setPixelColor(8, color);
          leds.setPixelColor(9, color);
          leds.setPixelColor(10, color);
          leds.setPixelColor(11, color);
          break;
      };
    }
      
  /**
   * Gestion des commandes
   */
  void getCmd () {
    DateTime now = RTC.now();
          cx = Serial.read();
          switch (cx) {
            case 97 : // mise à jour années
              mode = Serial.parseInt();
              if (mode < 0 || 99 <= mode)
                Serial.println ("Les années sont comprises entre 00 et 99");
              else {
                RTC.adjust(DateTime(2000 + mode, now.month(), now.day(), now.hour(), now.minute(), 0));
              }
              break;
            case 11 : // mise à jour mois
              mode = Serial.parseInt();
              if (mode < 1 || 12 <= mode)
                Serial.println ("Les mois sont comprises entre 01 et 12");
              else {
                RTC.adjust(DateTime(now.year(), mode, now.day(), now.hour(), now.minute(), 0));
              }
              break;
            case 106 : // mise à jour jours
              mode = Serial.parseInt();
              if (mode < 1 || 31 <= mode)
                Serial.println ("Les jours sont comprises entre 01 et 31");
              else {
                RTC.adjust(DateTime(now.year(), now.month(), mode, now.hour(), now.minute(), 0));
              }
              break;
            case 104 : // mise à jour heures
              mode = Serial.parseInt();
              if (mode < 0 || 24 <= mode)
                Serial.println ("Les heures sont comprises entre 00 et 23");
              else {
                RTC.adjust(DateTime(now.year(), now.month(), now.day(), mode, now.minute(), 0));
              }
              break;
            case 109 : // mise à jour minutes
              mode = Serial.parseInt();
              if (mode < 0 || 59 <= mode)
                Serial.println ("Les minutes sont comprises entre 00 et 59");
              else {
                RTC.adjust(DateTime(now.year(), now.month(), now.day(), now.hour(), mode, 0));
              }
              break;
            case 108 : // reglage luminosité
              mode = Serial.parseInt();
              if (mode < 0 || TOTAL_LIGHTLEVEL <= mode)
                Serial.println ("La luminosité est comprise entre 00 et 09");
              else {
                lightLevelIndex = mode;
                leds.setBrightness(lightLevels[lightLevelIndex]);
                Serial.print ("La luminosité est maintenant réglée à ");
                Serial.println (mode);
              }
              break;
            case 112 : // reglage palette
              mode = Serial.parseInt();
              if (mode < 0 || TOTAL_PALETTES <= mode)
                Serial.println ("La palette est comprise entre 00 et 09");
              else {
                palette = mode;
                Serial.print ("La palette est maintenant réglée à ");
                Serial.println (mode);
              }
              break;
            default :
              Serial.print (char(cx));
              Serial.println (" commande inconnue. Envoyez : xyy.");
              Serial.readString();
              Serial.println ("x = commande [Annee, Omois, Jour, Heure, Minute, Luminosité, Palette]");
              Serial.println ("yy = valeur à 2 chiffes");
          }
          Serial.print ("Il est maintenant : ");
          now = RTC.now();
          printDate (now);
  }

