// myL298N.js

(function(ext) {
    var device = null;
    
	var levels = {
		HIGH:1,
		LOW:0
	};
    
	ext.resetAll = function(){};
	
	ext.runArduino = function(){
		
	};
	ext.Stop = function() {
        device.send("Stop");
    };
	ext.Avant = function(){
		device.send("Avant");
	};
    ext.Arriere = function(){
        device.send("Arriere");
    };
    ext.Gauche = function(vit){
        device.send("Gauche ", vit);
    };
    ext.Droite = function(vit){
        device.send("Droite ", vit);
    };
    ext.Compense = function(d1, d2){
        device.send("Compensse ", d1, " - ", d2);
    };
    ext.Vitesse = function(vit){
        device.send("Vitesse ", vit);
    };
    ext.Pivote = function(sens, vit){
        device.send("Pivote ", sens, ", ", vit);
    };

    function processData(bytes) {
        trace(bytes);
    }

    // Extension API interactions
    var potentialDevices = [];
    ext._deviceConnected = function(dev) {
        potentialDevices.push(dev);

        if (!device) {
            tryNextDevice();
        }
    }

    function tryNextDevice() {
        // If potentialDevices is empty, device will be undefined.
        // That will get us back here next time a device is connected.
        device = potentialDevices.shift();
        if (device) {
            device.open({ stopBits: 0, bitRate: 115200, ctsFlowControl: 0 }, deviceOpened);
        }
    }

    function deviceOpened(dev) {
        if (!dev) {
            // Opening the port failed.
            tryNextDevice();
            return;
        }
        device.set_receive_handler('myL298N',function(data) {
            processData(data);
        });
    };

    ext._deviceRemoved = function(dev) {
        if(device != dev) return;
        device = null;
    };

    ext._shutdown = function() {
        if(device) device.close();
        device = null;
    };

    ext._getStatus = function() {
        if(!device) return {status: 1, msg: 'myL298N disconnected'};
        return {status: 2, msg: 'myL298N connected'};
    }

    var descriptor = {};
	ScratchExtensions.register('myL298N', descriptor, ext, {type: 'serial'});
})({});
