/**
 * myL298N.cpp - Library for L298N motor driver
 *
 * @Author Created by Yohendry Hurtado, 28 dec 2014 (L298N.cpp)
 * @Author Revise par Morceau Jean-Louis
 * @Version 0.1 (04 mars 2018) version initiale
 * @Version 0.2 (16/05/2018) fixation de la vitesse et modulation des virages
 * @Copyright Released into the public domain.
 */

#include "Arduino.h"
#include "myL298N.h"

struct Motor {
  int in1;
  int in2;
  int pwn;
  float delta = 1.0;
  int vit = 0;
};

Motor motors[2];

myL298N::myL298N(int ena, int in1, int in2, int in3, int in4, int enb) {
  pinMode (ena, OUTPUT);
  pinMode (in1, OUTPUT);
  pinMode (in2, OUTPUT);
  pinMode (in3, OUTPUT);
  pinMode (in4, OUTPUT);
  pinMode (enb, OUTPUT);

  motors[0].in1 = in1;
  motors[0].in2 = in2;
  motors[0].pwn = ena;

  motors[1].in1 = in3;
  motors[1].in2 = in4;
  motors[1].pwn = enb;

  this->full_stop();
}

void myL298N::drive_motors(int speed) {
  this->speed = speed%255;
  this->drive_motor(this->MOTOR_A,this->speed);
  this->drive_motor(this->MOTOR_B,this->speed);
}

void myL298N::drive_motor(int motor_index, int speed) {
  analogWrite(motors[motor_index].pwn, speed*motors[motor_index].delta);
}

void myL298N::forward() {
  if (this->mode > 1) this->full_stop();
  this->mode = 1;
  this->drive_motors(this->speed);
  this->setup_motors(HIGH,LOW,HIGH,LOW);
}

void myL298N::turn_right(int speed) {
  this->drive_motor(this->MOTOR_A, this->speed);
  this->drive_motor(this->MOTOR_B, this->speed * (speed%101)/100);
}

void myL298N::turn_left(int speed) {
  this->drive_motor(this->MOTOR_B, this->speed);
  this->drive_motor(this->MOTOR_A, this->speed * (speed%101)/100);
}

void myL298N::backward() {
  if (this->mode == 1 || this->mode == 3) this->full_stop();
  this->mode = 2;
  this->drive_motors(this->speed);
  this->setup_motors(LOW,HIGH,LOW,HIGH);
}

void myL298N::pivote(String sens, int speed) {
  if (this->mode == 1 || this->mode == 2) this->full_stop();
  this->mode = 3;
  this->drive_motor(this->MOTOR_A, speed%256);
  this->drive_motor(this->MOTOR_B, speed%256);
  if (sens == "droite") this->setup_motors(HIGH,LOW,LOW,HIGH);
  else this->setup_motors(LOW,HIGH,HIGH,LOW);
}

void myL298N::full_stop() {
  this->mode = 0;
  this->setup_motors(LOW,LOW,LOW,LOW);
  delay(30);
}

void myL298N::setup_deltas(int delta1, int delta2) {
  motors[0].delta = (delta1%101)/100;
  motors[1].delta = (delta2%101)/100;
}

void myL298N::setup_motors(int state1, int state2, int state3, int state4) {
  this->setup_motor(this->MOTOR_A,state1,state2);
  this->setup_motor(this->MOTOR_B,state3,state4);
}

void myL298N::setup_motor(int motor_index, int state1, int state2) {
  digitalWrite(motors[motor_index].in1, state1);
  digitalWrite(motors[motor_index].in2, state2);
}
