/*
 * Decompiled with CFR 0.152.
 */
package fr.mrc.simul.maquette;

import fr.mrc.simul.maquette.Maquette;
import fr.mrc.simul.maquette.SelectionFichier;
import fr.mrc.simul.maquette.TitreKeyListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Simul
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final String _ICON = "Simul.png";
    private static final String _LANG = "Lang/LangSimul";
    private final int _WIDTH = 800;
    private final int _HIGH = 680;
    public static ResourceBundle myLang;
    private JMenuBar menuBar = null;
    private static JLabel sbErr;
    private final JLabel sbMaq;
    private final JLabel sbProg;
    private final JLabel sbEtat;
    public TitreKeyListener ptTelec = null;
    private static Maquette myMaquette;
    private File pathRef = null;
    private boolean enModif = false;
    private boolean enEdition = false;
    private boolean prof = true;

    static {
        myMaquette = null;
    }

    public static void main(String[] args) {
        Locale curentLocale = Locale.getDefault();
        myLang = ResourceBundle.getBundle(_LANG, curentLocale);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new Simul(null);
                }
                catch (Exception e) {
                    Simul.Err(String.valueOf(e.toString()) + "/n" + myLang.getString("_ERR0"), false);
                }
            }
        });
    }

    private Simul() {
        this.setType(Window.Type.NORMAL);
        this.setBounds(100, 50, 800, 680);
        this.setResizable(false);
        String c = "";
        if (!this.prof) {
            c = myLang.getString("_ELEVE");
        }
        this.setTitle(String.valueOf(myLang.getString("_TITRE")) + " " + myLang.getString("_VERSION") + c);
        Image img = Toolkit.getDefaultToolkit().getImage("Simul.png");
        this.setIconImage(img);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        JPanel sp = new JPanel();
        sp.setLayout(new FlowLayout(0));
        this.sbMaq = new JLabel(myLang.getString("_SB_MAQ"));
        this.sbMaq.setPreferredSize(new Dimension(200, 20));
        this.sbMaq.setBorder(BorderFactory.createBevelBorder(1));
        sp.add(this.sbMaq);
        this.sbProg = new JLabel(myLang.getString("_SB_PROG"));
        this.sbProg.setPreferredSize(new Dimension(200, 20));
        this.sbProg.setBorder(BorderFactory.createBevelBorder(1));
        sp.add(this.sbProg);
        this.sbEtat = new JLabel("");
        this.sbEtat.setPreferredSize(new Dimension(50, 20));
        this.sbEtat.setBorder(BorderFactory.createBevelBorder(1));
        sp.add(this.sbEtat);
        sbErr = new JLabel("");
        sbErr.setFont(new Font("Tahoma", 0, 9));
        sbErr.setPreferredSize(new Dimension(310, 20));
        sbErr.setBorder(BorderFactory.createBevelBorder(1));
        sp.add(sbErr);
        this.getContentPane().add("South", sp);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu mnFichiers = new JMenu(myLang.getString("_MENU_FICHIERS"));
        mnFichiers.setMnemonic(73);
        this.menuBar.add(mnFichiers);
        JMenuItem mntmNouveau = new JMenuItem(myLang.getString("_MENU_CREER"), 78);
        mntmNouveau.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        mntmNouveau.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.offMaquette();
                Simul.this.newMaquette();
            }
        });
        mnFichiers.add(mntmNouveau);
        JMenuItem mntmOuvrir = new JMenuItem(myLang.getString("_MENU_OUVRIR"), 79);
        mntmOuvrir.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        mntmOuvrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.offMaquette();
                Simul.this.openMaquette();
            }
        });
        mnFichiers.add(mntmOuvrir);
        JMenuItem mntmEnregistrer = new JMenuItem(myLang.getString("_MENU_ENREGISTRER"), 69);
        mntmEnregistrer.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        mntmEnregistrer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.saveMaquette(false);
            }
        });
        mnFichiers.add(mntmEnregistrer);
        JMenuItem mntmEnregistrerSous = new JMenuItem(myLang.getString("_MENU_ENREGISTRERSOUS"));
        mntmEnregistrerSous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.saveMaquette(true);
            }
        });
        mnFichiers.add(mntmEnregistrerSous);
        JMenuItem mntmFermer = new JMenuItem(myLang.getString("_MENU_FERMER"), 70);
        mntmFermer.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        mntmFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.offMaquette();
            }
        });
        mnFichiers.add(mntmFermer);
        mnFichiers.addSeparator();
        JMenuItem mntmQuitter = new JMenuItem(myLang.getString("_MENU_QUITTER"), 81);
        mntmQuitter.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        mntmQuitter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.offMaquette();
                System.exit(0);
            }
        });
        mnFichiers.add(mntmQuitter);
        JMenu mnSimulation = new JMenu(myLang.getString("_MENU_SIMULATION"));
        this.menuBar.add((Component)mnSimulation);
        JCheckBoxMenuItem mntmLancer = new JCheckBoxMenuItem(myLang.getString("_MENU_ALIMENTER"), false);
        mntmLancer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                myMaquette.setAlim();
            }
        });
        ((Container)mnSimulation).add(mntmLancer);
        JMenuItem mntmCharger = new JMenuItem(myLang.getString("_MENU_PROGRAMMER"));
        mntmCharger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                myMaquette.setProg();
            }
        });
        ((Container)mnSimulation).add(mntmCharger);
        JMenu mnEdition = new JMenu(myLang.getString("_MENU_EDITION"));
        this.menuBar.add((Component)mnEdition);
        JCheckBoxMenuItem mntmModifier = new JCheckBoxMenuItem(myLang.getString("_MENU_MODIFIER"), false);
        mntmModifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.toggleEdit();
            }
        });
        ((Container)mnEdition).add(mntmModifier);
        JMenuItem mntmAjouter = new JMenuItem(myLang.getString("_MENU_AJOUTER"));
        mntmAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.ajoutMaquette();
            }
        });
        ((Container)mnEdition).add(mntmAjouter);
        JMenu mnAide = new JMenu(myLang.getString("_MENU_AIDE"));
        mnAide.setMnemonic(65);
        this.menuBar.add((Component)mnAide);
        JMenuItem mntmInfo = new JMenuItem(myLang.getString("_MENU_INFO"));
        mntmInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String zInfo = String.valueOf(myLang.getString("_TITRE")) + "\n\n";
                zInfo = String.valueOf(zInfo) + myLang.getString("_COPY") + " " + myLang.getString("_VERSION") + "\n" + myLang.getString("_AUTEUR") + "\n";
                zInfo = String.valueOf(zInfo) + myLang.getString("_LICENCE") + "\n\n";
                zInfo = String.valueOf(zInfo) + myLang.getString("_SB_INFO");
                JOptionPane.showMessageDialog(null, zInfo, myLang.getString("_DIALOG_INFORMATIONS"), 1);
            }
        });
        ((Container)mnAide).add(mntmInfo);
        this.ptTelec = new TitreKeyListener();
        this.addKeyListener(this.ptTelec);
        this.offMaquette();
    }

    public File getPath() {
        return this.pathRef.getParentFile();
    }

    private void saveMaquette(boolean force) {
        File myRef = this.pathRef;
        if (!this.enModif && !force) {
            return;
        }
        sbErr.setText("");
        if (myRef == null) {
            myRef = new File("./Nouvelle.mqt");
        } else if (!myRef.exists()) {
            int i = 1;
            while ((myRef = new File(String.valueOf(myRef.getPath()) + "/Nouvelle" + i++ + ".mqt")).exists()) {
            }
        }
        SelectionFichier myDialog = new SelectionFichier(myRef);
        myDialog.typeFichier("mqt");
        File p = myDialog.Save();
        p = myMaquette.Save(p);
        if (p != null) {
            this.pathRef = p;
            this.razModif();
            this.sbMaq.setText(String.valueOf(myLang.getString("_SB_MAQ")) + this.pathRef.getName());
        } else {
            sbErr.setText(myLang.getString("_ERR1C"));
        }
        this.repaint();
    }

    private void offMaquette() {
        if (myMaquette != null) {
            if (this.enModif) {
                int reponse = JOptionPane.showConfirmDialog(this, myLang.getString("_DIALOG_Q1"), myLang.getString("_DIALOG_CONFIRMATION"), 1, 3);
                if (reponse == 2) {
                    return;
                }
                if (reponse == 0) {
                    this.saveMaquette(true);
                }
            }
            this.remove(myMaquette);
            myMaquette.Destroy();
            myMaquette = null;
        }
        this.razModif();
        this.setEdit(false);
        this.setAlim(false);
        this.menuBar.getMenu(0).getItem(0).setEnabled(this.prof);
        this.menuBar.getMenu(0).getItem(3).setEnabled(false);
        this.menuBar.getMenu(0).getItem(4).setEnabled(false);
        this.menuBar.getMenu(1).setEnabled(false);
        this.menuBar.getMenu(2).setEnabled(false);
        sbErr.setText("");
        this.sbEtat.setText("");
        this.sbMaq.setText(myLang.getString("_SB_MAQ"));
        this.sbProg.setText(myLang.getString("_SB_PROG"));
        this.repaint();
    }

    private void newMaquette() {
        this.sbEtat.setText("");
        myMaquette = new Maquette(this);
        if (!myMaquette.newMaquette()) {
            myMaquette = null;
            sbErr.setText(myLang.getString("_ERR1B"));
            return;
        }
        File myRef = this.pathRef == null ? new File("./Nouvelle1.mqt") : new File(String.valueOf(this.pathRef.getParent()) + "/Nouvelle1.mqt");
        int i = 1;
        while (myRef.exists()) {
            myRef = new File(String.valueOf(myRef.getParent()) + "/Nouvelle" + i++ + ".mqt");
        }
        this.pathRef = myRef;
        this.getContentPane().add("Center", myMaquette);
        this.setModif(true);
        this.setEdit(true);
        this.menuBar.getMenu(0).getItem(0).setEnabled(this.prof);
        this.menuBar.getMenu(0).getItem(3).setEnabled(this.prof);
        this.menuBar.getMenu(0).getItem(4).setEnabled(this.prof);
        this.menuBar.getMenu(2).setEnabled(this.prof);
        this.sbMaq.setText(String.valueOf(myLang.getString("_SB_MAQ")) + this.pathRef.getName());
        this.repaint();
    }

    private void openMaquette() {
        this.sbEtat.setText("");
        myMaquette = new Maquette(this);
        File myRef = this.pathRef == null ? new File(".") : new File(this.pathRef.getPath());
        this.pathRef = myMaquette.initMaquette(myRef);
        if (this.pathRef == null) {
            myMaquette = null;
            sbErr.setText(myLang.getString("_ERR1A"));
            return;
        }
        this.getContentPane().add("Center", myMaquette);
        this.razModif();
        this.setEdit(false);
        this.menuBar.getMenu(0).getItem(0).setEnabled(this.prof);
        this.menuBar.getMenu(0).getItem(3).setEnabled(this.prof);
        this.menuBar.getMenu(0).getItem(4).setEnabled(this.prof);
        this.menuBar.getMenu(2).setEnabled(this.prof);
        this.sbMaq.setText(String.valueOf(myLang.getString("_SB_MAQ")) + this.pathRef.getName());
        this.sbEtat.setText(myLang.getString("_SB_OFF"));
        this.repaint();
    }

    public void setAlim(boolean e) {
        if (e) {
            this.sbEtat.setText(myLang.getString("_SB_ON"));
            this.menuBar.getMenu(1).getItem(0).setSelected(true);
            this.menuBar.getMenu(1).getItem(1).setEnabled(true);
            this.menuBar.getMenu(2).setEnabled(false);
        } else {
            this.sbEtat.setText(myLang.getString("_SB_OFF"));
            this.menuBar.getMenu(1).getItem(0).setSelected(false);
            this.menuBar.getMenu(1).getItem(1).setEnabled(false);
            this.menuBar.getMenu(2).setEnabled(this.prof);
        }
        this.repaint();
    }

    public boolean getAlim() {
        if (this.sbEtat.getText().equals("_SB_ON")) {
            return true;
        }
        if (this.sbEtat.getText().equals("_SB_RUN")) {
            return true;
        }
        return this.sbEtat.getText().equals("_SB_STOP");
    }

    public void setProg(String nom) {
        this.sbProg.setText(String.valueOf(myLang.getString("_SB_PROG")) + nom);
        this.menuBar.getMenu(1).getItem(0).setSelected(true);
    }

    public void setEtat(String e) {
        this.sbEtat.setText(myLang.getString(e));
    }

    private void setEdit(boolean e) {
        if (e) {
            this.enEdition = true;
            this.sbEtat.setText(myLang.getString("_SB_EDIT"));
            this.menuBar.getMenu(1).setEnabled(false);
            this.menuBar.getMenu(1).getItem(0).setSelected(false);
            this.menuBar.getMenu(1).getItem(1).setSelected(false);
            this.menuBar.getMenu(2).getItem(0).setSelected(this.prof);
            this.menuBar.getMenu(2).getItem(1).setEnabled(this.prof);
        } else {
            this.enEdition = false;
            this.sbEtat.setText("");
            this.menuBar.getMenu(1).setEnabled(true);
            this.menuBar.getMenu(2).getItem(0).setSelected(false);
            this.menuBar.getMenu(2).getItem(1).setEnabled(false);
        }
    }

    private void toggleEdit() {
        if (this.isEdit()) {
            if (this.isModif()) {
                this.saveMaquette(true);
            }
            this.setEdit(false);
        } else {
            this.setEdit(true);
        }
    }

    public boolean isEdit() {
        return this.enEdition;
    }

    private void ajoutMaquette() {
        if (this.isEdit()) {
            myMaquette.Composant();
            this.enModif = true;
        }
    }

    private boolean isModif() {
        return this.enModif;
    }

    public void setModif(boolean e) {
        this.enModif = true;
        this.menuBar.getMenu(0).getItem(2).setEnabled(this.prof);
    }

    private void razModif() {
        this.enModif = false;
        this.menuBar.getMenu(0).getItem(2).setEnabled(false);
    }

    public static void Err(String mesg, boolean warning) {
        if (!warning) {
            myMaquette.setAlim(false);
            JOptionPane.showMessageDialog(null, mesg, myLang.getString("_DIALOG_ERREUR"), 0);
        } else {
            JOptionPane.showMessageDialog(null, mesg, myLang.getString("_DIALOG_INFORMATIONS"), 2);
        }
        sbErr.setText(mesg);
    }

    /* synthetic */ Simul(Simul simul) {
        this();
    }
}

