/*
 * Decompiled with CFR 0.152.
 */
package fr.mrc.simul.picaxe;

import fr.mrc.simul.composants.Composant;
import fr.mrc.simul.maquette.Simul;
import fr.mrc.simul.picaxe.Picaxe;

public class P18X
extends Picaxe {
    private int infra;

    public P18X() {
        this.Connexions = new Composant[15];
        this.TypeConnexions = new int[]{21, 5, 5, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8};
        this.Variables = new int[14];
    }

    @Override
    public boolean isCmd(String cmd) throws Exception {
        switch (cmd) {
            case "infrain2": 
            case "infrain": {
                return true;
            }
            default: {
                return super.isCmd(cmd);
            }
            case "irin": 
        }
        throw new Exception(String.valueOf(cmd) + " : " + Simul.myLang.getString("_ERR20"));
    }

    @Override
    public int getInfra() {
        return 15;
    }

    @Override
    public String getPinInfra() {
        return "pin0";
    }

    @Override
    public void setReg(int r, int v) {
        if (r == 15) {
            this.infra = v;
        } else {
            if (r < 0 || r >= this.Variables.length) {
                Simul.Err("[" + r + "] " + Simul.myLang.getString("_ERR7"), true);
            }
            this.Variables[r] = v;
        }
    }

    @Override
    public int getReg(int r) {
        if (r == 15) {
            return this.infra;
        }
        int x = 0;
        if (r < 0 || r >= this.Variables.length) {
            Simul.Err("[" + r + "] " + Simul.myLang.getString("_ERR7"), true);
        } else {
            x = this.Variables[r];
        }
        return x;
    }

    @Override
    protected int Convert(String p) {
        switch (p) {
            case "E0": {
                return 0;
            }
            case "E1": {
                return 1;
            }
            case "E2": {
                return 2;
            }
            case "E6": {
                return 3;
            }
            case "E7": {
                return 4;
            }
            case "A0": {
                return 0;
            }
            case "A1": {
                return 1;
            }
            case "A2": {
                return 2;
            }
            case "S0": {
                return 5;
            }
            case "S1": {
                return 6;
            }
            case "S2": {
                return 7;
            }
            case "S3": {
                return 8;
            }
            case "S4": {
                return 9;
            }
            case "S5": {
                return 10;
            }
            case "S6": {
                return 11;
            }
            case "S7": {
                return 12;
            }
            case "X0": {
                return 13;
            }
            case "X1": {
                return 14;
            }
        }
        return -1;
    }

    @Override
    protected String ReverseConvert(String typ, int p) {
        switch (p) {
            case 0: {
                return "E0";
            }
            case 1: {
                return "E1";
            }
            case 2: {
                return "E2";
            }
            case 3: {
                return "E6";
            }
            case 4: {
                return "E7";
            }
            case 5: {
                return "S0";
            }
            case 6: {
                return "S1";
            }
            case 7: {
                return "S2";
            }
            case 8: {
                return "S3";
            }
            case 9: {
                return "S4";
            }
            case 10: {
                return "S5";
            }
            case 11: {
                return "S6";
            }
            case 12: {
                return "S7";
            }
            case 13: {
                return "X0";
            }
            case 14: {
                return "X1";
            }
        }
        return "";
    }
}

