/*
 * Decompiled with CFR 0.152.
 */
package fr.mrc.simul.composants;

import fr.mrc.simul.maquette.Simul;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;

public class Sound
extends Thread {
    private boolean jouer_ = false;
    private final double freq_;
    private final long duree_;
    private final SourceDataLine line_;
    private final ActionListener client_;

    public Sound(double freq, long duree, SourceDataLine line, ActionListener client) {
        this.freq_ = freq;
        this.duree_ = duree;
        this.line_ = line;
        this.client_ = client;
    }

    @Override
    public void run() {
        if (this.jouer_) {
            return;
        }
        this.jouer_ = true;
        AudioFormat fmt = this.line_.getFormat();
        float sampleRate = fmt.getSampleRate();
        int bufsize = this.line_.getBufferSize();
        int sampleSize = fmt.getSampleSizeInBits();
        int nbOctets = 0;
        int maxVal = 0;
        if (sampleSize == 8) {
            nbOctets = 1;
            maxVal = 127;
        } else if (sampleSize == 16) {
            nbOctets = 2;
            maxVal = Short.MAX_VALUE;
        } else {
            throw new Error(String.valueOf(Simul.myLang.getString("_ERR14")) + " : " + sampleSize);
        }
        boolean bigEndian = fmt.isBigEndian();
        int nbEchantillons = (int)Math.ceil((double)this.duree_ / 1000.0 * (double)sampleRate);
        byte[] audiosamples = new byte[bufsize];
        int i = 0;
        while (this.jouer_ && i < nbEchantillons) {
            int j = 0;
            while (this.jouer_ && j < bufsize && i < nbEchantillons) {
                int val = (int)((double)maxVal * Sound.sample(i++, this.freq_, sampleRate));
                if (nbOctets == 1) {
                    audiosamples[j++] = (byte)val;
                    continue;
                }
                if (bigEndian) {
                    audiosamples[j++] = (byte)((val & 0xFF00) >> 8);
                    audiosamples[j++] = (byte)(val & 0xFF);
                    continue;
                }
                audiosamples[j++] = (byte)(val & 0xFF);
                audiosamples[j++] = (byte)((val & 0xFF00) >> 8);
            }
            this.line_.write(audiosamples, 0, j);
        }
        this.line_.drain();
        this.client_.actionPerformed(new ActionEvent(this, 0, "SOUND_END"));
    }

    public void arret() {
        this.jouer_ = false;
        this.line_.flush();
    }

    public static double sample(int i, double freq, double rate) {
        double t = Math.IEEEremainder((double)i / rate, 1.0 / freq);
        if (t < 0.0) {
            t += 1.0 / freq;
        }
        return Math.sin(Math.PI * 2 * freq * t);
    }
}

