/*
 * Decompiled with CFR 0.152.
 */
package fr.mrc.simul.picaxe;

import fr.mrc.simul.composants.Afficheur;
import fr.mrc.simul.composants.Buzzer;
import fr.mrc.simul.maquette.Maquette;
import fr.mrc.simul.maquette.SelectionFichier;
import fr.mrc.simul.maquette.Simul;
import fr.mrc.simul.picaxe.Picaxe;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Timer;

class Interpreteur
implements Runnable {
    private Picaxe Pic;
    private String fichProgramme = "";
    private ArrayList<String> tableInstructions = new ArrayList();
    private Hashtable<String, Integer> tableLabels = new Hashtable();
    private Hashtable<String, String> tableSymboles = new Hashtable();
    private ArrayList<Integer> tablePile = new ArrayList();
    private Thread thread;
    private int debug = 0;
    private boolean isRunning = false;
    private boolean fintempo = false;
    private boolean sleep = false;
    private Timer timer = null;
    private boolean flagForNext = false;

    public Interpreteur(Picaxe mc) {
        this.Pic = mc;
        try {
            String ligne;
            SelectionFichier myDialog = new SelectionFichier(Maquette.Ecran.getPath());
            myDialog.typeFichier("bas");
            File fich = myDialog.Open();
            if (fich == null) {
                return;
            }
            this.fichProgramme = fich.getName();
            BufferedReader reader = new BufferedReader(new FileReader(fich));
            while ((ligne = reader.readLine()) != null) {
                String[] s;
                if (!ligne.matches("\"*[';]*\"")) {
                    ligne = ligne.replaceFirst("[';].*", "");
                }
                if ((ligne = ligne.trim()).length() == 0) continue;
                if (ligne.startsWith("symbol")) {
                    ligne = ligne.replaceFirst("symbol\\s*", "");
                    s = ligne.split("\\s*=\\s*", 2);
                    this.tableSymboles.put(s[0], s[1]);
                    continue;
                }
                if (ligne.matches("\\A[a-zA-Z_]\\w*:.*")) {
                    s = ligne.split(":\\s*", 2);
                    this.tableLabels.put(s[0].trim(), this.tableInstructions.size());
                    if (s[1].equals("")) continue;
                    ligne = s[1];
                }
                this.tableInstructions.add(ligne);
            }
            reader.close();
        }
        catch (IOException e) {
            Simul.Err(e.getMessage(), false);
        }
        this.thread = null;
        this.timer = null;
    }

    public String infoProg() {
        return this.fichProgramme;
    }

    public boolean getSleep() {
        return this.sleep;
    }

    void debugPrint(String mesg) {
        if (this.debug > 1) {
            System.out.print("[" + this.debug + "] ");
            System.out.println(mesg);
        }
    }

    void debugSet(int x) {
        this.debug = x;
    }

    public void Exec() throws Exception {
        this.flagForNext = false;
        int i = 0;
        while (i < this.tableInstructions.size()) {
            String[] s = this.tableInstructions.get(i).split("\\s+", 2);
            String mnemo = s[0];
            String param = "";
            if (s.length > 1) {
                param = s[1].trim();
            }
            switch (mnemo.toLowerCase()) {
                case "do": {
                    i = this.cmd_do(param, i);
                    break;
                }
                case "loop": {
                    i = this.cmd_loop(param, i);
                    break;
                }
                case "if": {
                    i = this.cmd_if(param, i);
                    break;
                }
                case "else": {
                    i = this.jump("endif", i);
                    break;
                }
                case "for": {
                    i = this.cmd_for(param, i);
                    break;
                }
                case "next": {
                    i = this.cmd_next(param, i);
                    break;
                }
                case "exit": {
                    i = this.cmd_exit(i);
                    break;
                }
                case "gosub": {
                    i = this.cmd_gosub(param, i);
                    break;
                }
                case "call": {
                    i = this.cmd_gosub(param, i);
                    break;
                }
                case "return": {
                    i = this.cmd_return();
                    break;
                }
                case "goto": {
                    i = this.cmd_goto(param);
                    break;
                }
                case "stop": {
                    this.cmd_stop();
                    break;
                }
                case "high": {
                    this.cmd_high(param);
                    break;
                }
                case "low": {
                    this.cmd_low(param);
                    break;
                }
                case "toggle": {
                    this.cmd_toggle(param);
                    break;
                }
                case "pause": {
                    this.cmd_pause(param);
                    break;
                }
                case "wait": {
                    this.cmd_wait(param);
                    break;
                }
                case "nap": {
                    this.cmd_nap(param);
                    break;
                }
                case "sleep": {
                    this.cmd_sleep(param);
                    break;
                }
                case "sound": {
                    this.cmd_sound(param);
                    break;
                }
                case "readtemp": {
                    this.cmd_readtemp(param);
                    break;
                }
                case "readadc": {
                    this.cmd_readadc(param);
                    break;
                }
                case "serout": {
                    this.cmd_serout(param);
                    break;
                }
                case "random": {
                    this.cmd_random(param);
                    break;
                }
                case "let": {
                    this.cmd_let(param);
                    break;
                }
                case "irin": {
                    i = this.cmd_irin(param, i);
                    break;
                }
                case "infrain": {
                    this.cmd_infrain(i);
                    break;
                }
                default: {
                    if (this.isReg(mnemo)) {
                        this.cmd_let(String.valueOf(mnemo) + " " + param);
                        break;
                    }
                    throw new Exception(String.valueOf(Simul.myLang.getString("_ERR8")) + " : " + this.tableInstructions.get(i));
                }
                case "endif": 
            }
            if (!this.isRunning) break;
            ++i;
        }
        if (this.isRunning) {
            this.arret();
        }
    }

    @Override
    public void run() {
        try {
            this.Exec();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                Simul.Err(e.toString(), false);
            }
            Simul.Err(e.getMessage(), false);
        }
        this.thread = null;
    }

    public void arret() {
        Maquette.Ecran.setEtat("_SB_STOP");
        if (this.thread != null) {
            this.isRunning = false;
            this.thread = null;
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
        }
        this.isRunning = true;
        this.thread.start();
    }

    private int swapVal(String s) throws Exception {
        String a = this.tableSymboles.get(s);
        if (a == null) {
            a = s;
        }
        try {
            if (a.startsWith("$")) {
                return Integer.parseInt(a.substring(1), 16);
            }
            if (a.startsWith("0x")) {
                return Integer.parseInt(a.substring(2), 16);
            }
            if (a.startsWith("%")) {
                return Integer.parseInt(a.substring(1), 2);
            }
            if (a.startsWith("b")) {
                return this.Pic.getReg(Integer.parseInt(a.substring(1), 10));
            }
            if (a.startsWith("w")) {
                return this.Pic.getReg(Integer.parseInt(a.substring(1), 10));
            }
            if (a.startsWith("pinB.")) {
                return this.Pic.get("B." + a.substring(5));
            }
            if (a.startsWith("pinC.")) {
                return this.Pic.get("C." + a.substring(5));
            }
            if (a.startsWith("pinA.")) {
                return this.Pic.get("A" + a.substring(5));
            }
            if (a.startsWith("pin")) {
                return this.Pic.get("E" + a.substring(3));
            }
            return Integer.parseInt(a, 10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("[" + s + "] " + Simul.myLang.getString("_ERR11"));
        }
    }

    private int swapVar(String s) throws Exception {
        String a = this.tableSymboles.get(s);
        if (a == null) {
            a = s;
        }
        try {
            if (a.startsWith("b")) {
                return this.Pic.getReg(Integer.parseInt(a.substring(1), 10));
            }
            if (a.startsWith("w")) {
                return this.Pic.getReg(Integer.parseInt(a.substring(1), 10));
            }
            if (a.startsWith("infra")) {
                return this.Pic.getReg(this.Pic.getInfra());
            }
            if (a.startsWith("pinC.")) {
                return this.Pic.get("C." + a.substring(5));
            }
            if (a.startsWith("pinB.")) {
                return this.Pic.get("B." + a.substring(5));
            }
            if (a.startsWith("pinA.")) {
                return this.Pic.get("A" + a.substring(5));
            }
            if (a.startsWith("pin")) {
                return this.Pic.get("E" + a.substring(3));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new Exception("[" + s + "] " + Simul.myLang.getString("_ERR17"));
    }

    private int swapReg(String s) throws Exception {
        String a = this.tableSymboles.get(s);
        if (a == null) {
            a = s;
        }
        try {
            if (a.startsWith("b")) {
                return this.Pic.getReg(Integer.parseInt(a.substring(1), 10));
            }
            if (a.startsWith("w")) {
                return this.Pic.getReg(Integer.parseInt(a.substring(1), 10));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new Exception("[" + s + "] " + Simul.myLang.getString("_ERR17"));
    }

    private boolean isReg(String s) {
        String a = this.tableSymboles.get(s);
        if (a == null) {
            a = s;
        }
        if (a.startsWith("b")) {
            return true;
        }
        return a.startsWith("w");
    }

    private int whoIsReg(String s) throws Exception {
        String a = this.tableSymboles.get(s);
        if (a == null) {
            a = s;
        }
        try {
            if (a.startsWith("b")) {
                return Integer.parseInt(a.substring(1), 10);
            }
            if (a.startsWith("w")) {
                return Integer.parseInt(a.substring(1), 10);
            }
            if (a.startsWith("infra")) {
                return this.Pic.getInfra();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new Exception("[" + s + "] " + Simul.myLang.getString("_ERR17"));
    }

    private String swapOutput(String pre, String s) throws Exception {
        String a = this.tableSymboles.get(s);
        if (a == null) {
            a = s;
        }
        try {
            if (a.startsWith("$")) {
                return String.valueOf(pre) + Integer.parseInt(a.substring(1), 16);
            }
            if (a.startsWith("0x")) {
                return String.valueOf(pre) + Integer.parseInt(a.substring(2), 16);
            }
            if (a.startsWith("%")) {
                return String.valueOf(pre) + Integer.parseInt(a.substring(1), 2);
            }
            if (a.startsWith("b")) {
                return String.valueOf(pre) + this.Pic.getReg(Integer.parseInt(a.substring(1), 10));
            }
            if (a.startsWith("w")) {
                return String.valueOf(pre) + this.Pic.getReg(Integer.parseInt(a.substring(1), 10));
            }
            if (a.startsWith("B.")) {
                return a;
            }
            if (a.startsWith("C.")) {
                return a;
            }
            return String.valueOf(pre) + Integer.parseInt(a, 10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("[" + s + "] " + Simul.myLang.getString("_ERR9"));
        }
    }

    private int swapValOut(String s) throws Exception {
        String a = this.tableSymboles.get(s);
        if (a == null) {
            a = s;
        }
        try {
            if (a.startsWith("$")) {
                return Integer.parseInt(a.substring(1), 16);
            }
            if (a.startsWith("0x")) {
                return Integer.parseInt(a.substring(2), 16);
            }
            if (a.startsWith("%")) {
                return Integer.parseInt(a.substring(1), 2);
            }
            if (a.startsWith("b")) {
                return this.Pic.getReg(Integer.parseInt(a.substring(1), 10));
            }
            if (a.startsWith("w")) {
                return this.Pic.getReg(Integer.parseInt(a.substring(1), 10));
            }
            return Integer.parseInt(a, 10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("[" + s + "] " + Simul.myLang.getString("_ERR9"));
        }
    }

    private boolean evalCond(String s) throws Exception {
        s = s.replaceAll("\\s*(<=|>=|<>|!=|AND|OR|and|or|[=<>])\\s*", " $1 ");
        String[] cond = s.split("\\s+");
        int i = 0;
        boolean res2 = true;
        while (cond.length > i) {
            boolean res1 = res2;
            int a = this.swapVar(cond[i++]);
            String op = cond[i++];
            int b = this.swapVal(cond[i++]);
            switch (op) {
                case "=": {
                    res2 = a == b;
                    break;
                }
                case "is": {
                    res2 = a == b;
                    break;
                }
                case "<>": {
                    res2 = a != b;
                    break;
                }
                case "!=": {
                    res2 = a != b;
                    break;
                }
                case "<": {
                    res2 = a < b;
                    break;
                }
                case ">": {
                    res2 = a > b;
                    break;
                }
                case "<=": {
                    res2 = a <= b;
                    break;
                }
                case ">=": {
                    res2 = a >= b;
                    break;
                }
                default: {
                    throw new Exception("[" + op + "] " + Simul.myLang.getString("_ERR19"));
                }
            }
            if (i <= 4) continue;
            switch (cond[i - 4]) {
                case "AND": {
                    res2 = res1 && res2;
                    break;
                }
                case "OR": {
                    res2 = res1 || res2;
                    break;
                }
                case "and": {
                    res2 = res1 && res2;
                    break;
                }
                case "or": {
                    res2 = res1 || res2;
                    break;
                }
                default: {
                    throw new Exception("[" + cond[i - 4] + "] " + Simul.myLang.getString("_ERR19"));
                }
            }
        }
        return res2;
    }

    private int jump(String rech, int i) throws Exception {
        while (i <= this.tableInstructions.size()) {
            String[] s = this.tableInstructions.get(i).split("\\s+", 2);
            String cmd = s[0].toLowerCase();
            if (cmd.equals(rech)) {
                return i;
            }
            switch (cmd) {
                case "for": {
                    i = this.jump("next", i + 1);
                    break;
                }
                case "do": {
                    i = this.jump("loop", i + 1);
                    break;
                }
                case "if": {
                    i = this.jump("endif", i + 1);
                    break;
                }
                case "endif": {
                    if (!rech.equals("else")) break;
                    return i;
                }
            }
            ++i;
        }
        throw new Exception("[" + rech + "] " + Simul.myLang.getString("_ERR2"));
    }

    private int cmd_infrain(int pos) throws Exception {
        this.cmd_irin0("infrain, infra", pos);
        int infra = this.Pic.getInfra();
        switch (this.Pic.getReg(infra)) {
            case 0: {
                this.Pic.setReg(infra, 1);
                break;
            }
            case 1: {
                this.Pic.setReg(infra, 2);
                break;
            }
            case 2: {
                this.Pic.setReg(infra, 3);
                break;
            }
            case 3: {
                this.Pic.setReg(infra, 4);
                break;
            }
            case 4: {
                this.Pic.setReg(infra, 5);
                break;
            }
            case 5: {
                this.Pic.setReg(infra, 6);
                break;
            }
            case 6: {
                this.Pic.setReg(infra, 7);
                break;
            }
            case 7: {
                this.Pic.setReg(infra, 8);
                break;
            }
            case 8: {
                this.Pic.setReg(infra, 9);
                break;
            }
            case 9: {
                this.Pic.setReg(infra, 11);
                break;
            }
            case 11: {
                this.Pic.setReg(infra, 14);
                break;
            }
            case 16: {
                this.Pic.setReg(infra, 12);
                break;
            }
            case 17: {
                this.Pic.setReg(infra, 15);
                break;
            }
            case 18: {
                this.Pic.setReg(infra, 10);
                break;
            }
            case 19: {
                this.Pic.setReg(infra, 13);
                break;
            }
            case 21: {
                this.Pic.setReg(infra, 17);
                break;
            }
            case 98: {
                this.Pic.setReg(infra, 16);
                break;
            }
            default: {
                this.Pic.setReg(infra, 255);
            }
        }
        return pos;
    }

    private int cmd_irin(String s, int pos) throws Exception {
        this.Pic.isCmd("irin");
        return this.cmd_irin0(s, pos);
    }

    private int cmd_irin0(String s, int pos) throws Exception {
        String[] q;
        int ret = pos;
        int val = 255;
        this.fintempo = false;
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Interpreteur.this.fintempo = true;
            }
        };
        if (s.startsWith("[")) {
            q = s.split("\\s*]\\s*", 2);
            String[] p = q[0].split("\\s*,\\s*", 2);
            int d = this.swapVal(p[0].substring(1));
            this.timer = new Timer(d, action);
            s = q[1].split("\\s*,\\s*", 2)[1];
            this.timer.start();
            if (p.length > 1) {
                Integer a = this.tableLabels.get(p[1]);
                if (a == null) {
                    throw new Exception("[" + q[1] + "] " + Simul.myLang.getString("_ERR10"));
                }
                ret = a - 1;
            }
        }
        q = s.split("\\s*,\\s*", 2);
        int reg = this.whoIsReg(q[1]);
        String broche = q[0].startsWith("pin") ? q[0] : (q[0].startsWith("infrain") ? this.Pic.getPinInfra() : "pin" + q[0]);
        do {
            val = this.swapVar(broche);
        } while (!this.fintempo && val == 255);
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = null;
        if (this.fintempo) {
            pos = ret;
        }
        this.Pic.setReg(reg, val);
        return pos;
    }

    private int cmd_exit(int pos) throws Exception {
        int ret = this.tablePile.remove(this.tablePile.size() - 1);
        String cmd = this.tableInstructions.get(ret);
        if (cmd.startsWith("for")) {
            ret = this.jump("next", pos + 1);
        }
        if (cmd.startsWith("do")) {
            ret = this.jump("loop", pos + 1);
        }
        return ret;
    }

    private int cmd_for(String s, int pos) throws Exception {
        int tmp;
        this.tablePile.add(pos - 1);
        String[] cond = s.split("\\s+to\\s+", 2);
        String[] cond2 = cond[1].split("\\s+step\\s+", 2);
        String[] let = cond[0].split("\\s+=\\s+", 2);
        int reg = this.whoIsReg(let[0]);
        int pas = this.swapVal(cond2[1]);
        if (!this.flagForNext) {
            int val = this.swapVal(let[1]);
            this.Pic.setReg(reg, val);
        } else {
            tmp = this.Pic.getReg(reg);
            this.Pic.setReg(reg, tmp + pas);
        }
        this.flagForNext = false;
        tmp = this.Pic.getReg(reg);
        int fin = this.swapVal(cond2[0]);
        if (pas >= 0 && tmp <= fin) {
            return pos;
        }
        if (pas < 0 && tmp >= fin) {
            return pos;
        }
        this.tablePile.remove(this.tablePile.size() - 1);
        return this.jump("next", pos + 1);
    }

    private int cmd_next(String s, int pos) throws Exception {
        int ret = this.tablePile.remove(this.tablePile.size() - 1);
        this.flagForNext = true;
        return ret;
    }

    private int cmd_do(String s, int pos) throws Exception {
        this.tablePile.add(pos - 1);
        if ("".equals(s)) {
            return pos;
        }
        String[] cond = s.split("\\s+", 2);
        if (!"until".equals(cond[0]) && !"while".equals(cond[0])) {
            throw new Exception("[" + cond[0] + "] " + Simul.myLang.getString("_ERR18"));
        }
        boolean res2 = this.evalCond(cond[1]);
        if ("while".equals(cond[0])) {
            boolean bl = res2 = !res2;
        }
        if (res2) {
            this.tablePile.remove(this.tablePile.size() - 1);
            return this.jump("loop", pos + 1);
        }
        return pos;
    }

    private int cmd_loop(String s, int pos) throws Exception {
        int ret = this.tablePile.remove(this.tablePile.size() - 1);
        if ("".equals(s)) {
            return ret;
        }
        String[] cond = s.split("\\s+", 2);
        if (!"until".equals(cond[0]) && !"while".equals(cond[0])) {
            throw new Exception("[" + cond[0] + "] " + Simul.myLang.getString("_ERR18"));
        }
        boolean res2 = this.evalCond(cond[1]);
        if ("while".equals(cond[0])) {
            boolean bl = res2 = !res2;
        }
        if (res2) {
            return pos;
        }
        return ret;
    }

    private void cmd_toggle(String s) throws Exception {
        String pin;
        int y = this.Pic.get(pin = this.swapOutput("S", s));
        this.Pic.set(pin, y == 1 ? 0 : 1);
    }

    private void cmd_high(String s) throws Exception {
        String pin = this.swapOutput("S", s);
        this.Pic.set(pin, 1);
    }

    private void cmd_low(String s) throws Exception {
        String pin = this.swapOutput("S", s);
        this.Pic.set(pin, 0);
    }

    private void cmd_pins(int val) {
        String[] p;
        String[] stringArray = p = this.Pic.Occupe("S");
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            String p1;
            int x = Integer.parseInt((p1 = stringArray[n2]).substring(1), 10);
            int y = (int)Math.pow(2.0, x) & val;
            this.Pic.set(p1, y > 0 ? 1 : 0);
            ++n2;
        }
    }

    private void cmd_sound(String s) throws Exception {
        String[] x = s.trim().split(",");
        String out = this.swapOutput("S", x[0].trim());
        int nb = 1;
        while (nb < x.length) {
            x[nb] = x[nb].trim();
            x[nb] = x[nb].substring(1, x[nb].length() - 1);
            String[] y = x[nb].split(",");
            int freq = this.swapValOut(y[0].trim());
            int duree = this.swapValOut(y[1].trim());
            ((Buzzer)this.Pic.Qui(out)).jouer(freq, duree);
            ++nb;
        }
    }

    private void cmd_pause(String s) throws Exception {
        Thread.sleep(this.swapValOut(s));
    }

    private void cmd_wait(String s) throws Exception {
        Thread.sleep(this.swapValOut(s) * 1000);
    }

    private void cmd_nap(String s) throws Exception {
        int p = 18 * (this.swapValOut(s) + 1);
        Thread.sleep(p);
    }

    private void cmd_sleep(String s) throws Exception {
        int p = this.swapValOut(s) * 2300;
        Thread.sleep(p);
    }

    private int cmd_goto(String s) throws Exception {
        Integer a = this.tableLabels.get(s);
        if (a == null) {
            throw new Exception("[" + s + "] " + Simul.myLang.getString("_ERR10"));
        }
        return a - 1;
    }

    private int cmd_gosub(String s, int ret) throws Exception {
        this.tablePile.add(ret);
        Integer a = this.tableLabels.get(s);
        if (a == null) {
            throw new Exception("[" + s + "] " + Simul.myLang.getString("_ERR10"));
        }
        return a - 1;
    }

    private int cmd_return() {
        return this.tablePile.remove(this.tablePile.size() - 1);
    }

    private void cmd_stop() {
        this.arret();
    }

    private int cmd_if(String s, int adr) throws Exception {
        String[] q = s.split("\\s+then\\s*");
        if (this.evalCond(q[0])) {
            if (q.length == 2) {
                q[1] = q[1].replaceFirst("\\s*goto\\s*", "");
                return this.cmd_goto(q[1].trim());
            }
            return adr;
        }
        if (q.length == 2) {
            return adr;
        }
        return this.jump("else", adr + 1);
    }

    private void cmd_random(String par) throws Exception {
        double val = Math.random() * 65536.0;
        int r = this.whoIsReg(par);
        this.Pic.setReg(r, (int)val);
    }

    private void cmd_let(String s) throws Exception {
        String[] x = s.split("\\s*=\\s*");
        if (x[0].equals("pins")) {
            this.cmd_pins(this.swapVal(x[1]));
            return;
        }
        int reg = this.whoIsReg(x[0]);
        x[1] = x[1].replaceAll("\\s*([\\+\\-\\*\\/\\%]|AND|OR|NAND|XOR|NOR|and|or|nand|xor|nor)\\s*", " $1 ");
        String[] part = x[1].split("\\s+");
        int val1 = this.swapVal(part[0]);
        if (part.length == 1) {
            this.Pic.setReg(reg, val1);
            return;
        }
        int val2 = this.swapVal(part[2]);
        switch (part[1]) {
            case "+": {
                this.Pic.setReg(reg, val1 + val2);
                break;
            }
            case "-": {
                this.Pic.setReg(reg, val1 - val2);
                break;
            }
            case "*": {
                this.Pic.setReg(reg, val1 * val2);
                break;
            }
            case "/": {
                this.Pic.setReg(reg, val1 / val2);
                break;
            }
            case "%": {
                this.Pic.setReg(reg, val1 % val2);
                break;
            }
            case "AND": {
                this.Pic.setReg(reg, val1 & val2);
                break;
            }
            case "OR": {
                this.Pic.setReg(reg, val1 | val2);
                break;
            }
            case "NAND": {
                this.Pic.setReg(reg, ~(val1 & val2));
                break;
            }
            case "NOR": {
                this.Pic.setReg(reg, ~(val1 / val2));
                break;
            }
            case "XOR": {
                this.Pic.setReg(reg, val1 ^ val2);
                break;
            }
            case "and": {
                this.Pic.setReg(reg, val1 & val2);
                break;
            }
            case "or": {
                this.Pic.setReg(reg, val1 | val2);
                break;
            }
            case "nand": {
                this.Pic.setReg(reg, ~(val1 & val2));
                break;
            }
            case "nor": {
                this.Pic.setReg(reg, ~(val1 / val2));
                break;
            }
            case "xor": {
                this.Pic.setReg(reg, val1 ^ val2);
                break;
            }
            default: {
                throw new Exception("[" + part[1] + "] " + Simul.myLang.getString("_ERR19"));
            }
        }
    }

    private void cmd_readadc(String s) throws Exception {
        String[] x = s.trim().split(",");
        String ent = this.swapOutput("A", x[0].trim());
        int reg = this.whoIsReg(x[1].trim());
        int xx = this.Pic.get(ent);
        this.Pic.setReg(reg, xx);
    }

    private void cmd_readtemp(String s) throws Exception {
        String[] x = s.trim().split(",");
        String ent = this.swapOutput("E", x[0].trim());
        int reg = this.whoIsReg(x[1].trim());
        int xx = this.Pic.get(ent);
        this.Pic.setReg(reg, xx);
    }

    private void cmd_serout(String s) throws Exception {
        String[] x = s.trim().split("\\s*,\\s*", 3);
        String sort = this.swapOutput("S", x[0]);
        String t = x[2].substring(1, x[2].length() - 2);
        x = t.trim().split("\\s*,\\s*");
        t = "";
        int i = 0;
        while (i < x.length) {
            t = x[i].startsWith("#") ? String.valueOf(t) + "\"" + this.swapValOut(x[i].substring(1)) + "\"" : (x[i].startsWith("\"") ? String.valueOf(t) + x[i] : String.valueOf(t) + this.swapValOut(x[i]));
            if (i < x.length - 1) {
                t = String.valueOf(t) + ",";
            }
            ++i;
        }
        Afficheur xx = (Afficheur)this.Pic.Qui(sort);
        xx.Ecrit(t);
    }
}

