/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

class Buzzer
extends Led
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected double freq = 800.0;
    protected int duree = 5000;
    private Sound Bruit = null;

    public Buzzer() {
        this.sonImg = "BUZZER";
        this.cnx = "S";
    }

    @Override
    public StringTokenizer Init(String ou, StringTokenizer l) {
        l = super.Init(ou, l);
        return l;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String commande = e.getActionCommand();
        if (commande.equals("SOUND_END")) {
            if (this.Bruit != null) {
                this.Bruit.arret();
            }
            this.Bruit = null;
            if (this.Etat == 1) {
                this.play();
            }
        }
    }

    @Override
    public void set(String qui, int e) {
        if (this.Etat == 0 && e == 1 && this.Bruit == null) {
            super.set(qui, e);
            this.play();
        }
        if (e == 0) {
            super.set(qui, e);
            if (this.Bruit != null) {
                this.Bruit.arret();
                this.Bruit = null;
            }
        }
    }

    public void jouer(int f, int d) {
        this.freq = f;
        this.duree = d;
        this.set(this.Pin, 0);
        this.play();
    }

    public void play() {
        float sampleRate = 20500.0f;
        int sampleSize = 8;
        boolean bigEndian = true;
        boolean signed = true;
        AudioFormat audiofmt = new AudioFormat(20500.0f, 8, 1, true, true);
        SourceDataLine line = null;
        try {
            line = AudioSystem.getSourceDataLine(audiofmt);
            line.open(audiofmt);
        }
        catch (LineUnavailableException lue) {
            throw new Error(String.valueOf(Simul.myLang.getString("_ERR15")) + " : " + audiofmt);
        }
        line.start();
        this.Bruit = new Sound(this.freq, this.duree, line, this);
        this.Bruit.start();
    }

    @Override
    public void Hold() {
        this.set(this.Pin, 0);
    }
}

