/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Maquette
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String _RES_APPLI = "ressources/";
    private Image imgFond = null;
    private boolean enExecution = false;
    private boolean enProgramme = false;
    private final ZDialogMaq Info = new ZDialogMaq();
    public static Picaxe myPicaxe = null;
    public static Simul Ecran = null;

    public Maquette(Simul ecr) {
        Ecran = ecr;
        this.setLayout(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Maquette.this.evtMC0(evt);
            }
        });
    }

    public File initMaquette(File f) {
        BufferedReader reader;
        FileReader file;
        SelectionFichier myDialog = new SelectionFichier(f);
        myDialog.typeFichier("mqt");
        f = myDialog.Open();
        if (f == null) {
            return null;
        }
        try {
            file = new FileReader(f.getAbsolutePath());
            reader = new BufferedReader(file);
        }
        catch (FileNotFoundException e) {
            Simul.Err(e.getMessage(), true);
            return null;
        }
        String c = "";
        try {
            String ligne;
            while ((ligne = reader.readLine()) != null) {
                Class<?> classe;
                if (ligne.length() == 0) continue;
                if (ligne.charAt(0) == '\'') {
                    this.Info.info = String.valueOf(this.Info.info) + ligne.substring(1) + "\r\n";
                    continue;
                }
                StringTokenizer l = new StringTokenizer(ligne, ",", false);
                String s = l.nextToken().trim();
                if (s.startsWith("F=")) {
                    this.Info.fichFond = s.substring(2).trim();
                    File fm = new File(_RES_APPLI + this.Info.fichFond);
                    if (!fm.exists()) {
                        throw new FileNotFoundException();
                    }
                    this.imgFond = new ImageIcon(_RES_APPLI + this.Info.fichFond).getImage();
                    continue;
                }
                if (s.startsWith("P=")) {
                    this.Info.processeur = s.substring(2).trim();
                    classe = Class.forName(this.Info.processeur);
                    myPicaxe = (Picaxe)classe.newInstance();
                    continue;
                }
                if (this.Info.processeur.length() == 0) {
                    reader.close();
                    file.close();
                    throw new Exception(Simul.myLang.getString("_ERR1"));
                }
                c = l.nextToken().trim();
                classe = Class.forName(c);
                Composant o = (Composant)classe.newInstance();
                o.Init(s, l);
                myPicaxe.Connect(s, o);
                this.add(o);
                o.repaint();
            }
            reader.close();
            file.close();
        }
        catch (NoSuchElementException e) {
            Simul.Err(String.valueOf(c) + " : " + Simul.myLang.getString("_ERR2"), false);
        }
        catch (FileNotFoundException e) {
            Simul.Err(String.valueOf(this.Info.fichFond) + " : " + Simul.myLang.getString("_ERR16"), false);
        }
        catch (Exception e) {
            Simul.Err(e.toString(), true);
        }
        return f;
    }

    public boolean newMaquette() {
        boolean ret = false;
        OptMaquette dialog = new OptMaquette();
        dialog.setDefaultCloseOperation(2);
        ZDialogMaq zd = new ZDialogMaq();
        zd = dialog.showZDialog(zd);
        if (zd.valide) {
            try {
                this.Info.fichFond = zd.fichFond;
                File f = new File(_RES_APPLI + this.Info.fichFond);
                if (!f.exists()) {
                    throw new FileNotFoundException();
                }
                this.imgFond = new ImageIcon(_RES_APPLI + this.Info.fichFond).getImage();
                this.Info.processeur = zd.processeur;
                this.Info.info = zd.info;
                Class<?> classe = Class.forName(this.Info.processeur);
                myPicaxe = (Picaxe)classe.newInstance();
                ret = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                Simul.Err(String.valueOf(this.Info.processeur) + " : " + Simul.myLang.getString("_ERR3"), false);
            }
            catch (FileNotFoundException e) {
                Simul.Err(String.valueOf(this.Info.fichFond) + " : " + Simul.myLang.getString("_ERR16"), false);
            }
        }
        return ret;
    }

    public void Destroy() {
        myPicaxe.Run(false);
        Ecran.nomProgramme("");
        Ecran.progMaquette("_SB_ON");
        this.enProgramme = false;
    }

    private void evtMC0(MouseEvent evt) {
        if (Ecran.isModif() && evt.getClickCount() == 2) {
            OptMaquette dialog = new OptMaquette();
            dialog.setDefaultCloseOperation(2);
            ZDialogMaq zd = new ZDialogMaq();
            zd.fichFond = this.Info.fichFond;
            zd.processeur = this.Info.processeur;
            zd.info = this.Info.info;
            zd = dialog.showZDialog(zd);
            if (zd.valide) {
                this.Info.fichFond = zd.fichFond;
                this.imgFond = new ImageIcon(_RES_APPLI + this.Info.fichFond).getImage();
                this.Info.processeur = zd.processeur;
                this.Info.info = zd.info;
                Ecran.setModif();
                this.repaint();
            }
        }
    }

    public void Composant() {
        String[] l = new String[2];
        String nom = (String)JOptionPane.showInputDialog(null, Simul.myLang.getString("_DIALOG_Q2"), Simul.myLang.getString("_DIALOG_AJOUT"), 3, null, Composant.Liste, Composant.Liste[0]);
        try {
            Class<?> classe = Class.forName(nom);
            Composant o = (Composant)classe.newInstance();
            switch (nom) {
                case "Alim": {
                    l[1] = "X0";
                    break;
                }
                case "Prog": {
                    l[1] = "X1";
                    break;
                }
                default: {
                    l = myPicaxe.Libre(o.cnx.substring(0, 1));
                }
            }
            o.Init(l[1]);
            myPicaxe.Connect(l[1], o);
            this.add(o);
            o.repaint();
            Ecran.setModif();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            Simul.Err(String.valueOf(nom) + " : " + Simul.myLang.getString("_ERR3"), false);
        }
    }

    public void setAlim(boolean e) {
        if (Ecran.isModif()) {
            return;
        }
        this.enExecution = e;
        Ecran.alimMaquette(e);
        if (e) {
            if (this.enProgramme) {
                myPicaxe.Reset();
                myPicaxe.Run(true);
                Ecran.progMaquette("_SB_RUN");
            } else {
                Ecran.progMaquette("_SB_ON");
            }
        } else {
            myPicaxe.Run(false);
            myPicaxe.Hold();
            Ecran.progMaquette("_SB_OFF");
        }
    }

    public void setAlim() {
        try {
            int e = myPicaxe.get("X0");
            if (e == 0) {
                myPicaxe.set("X0", 1);
            } else {
                myPicaxe.set("X0", 0);
            }
            this.setAlim(e == 0);
        }
        catch (Exception e) {
            Simul.Err(e.getMessage(), false);
        }
    }

    public void setProg(boolean e) {
        if (Ecran.isModif()) {
            return;
        }
        try {
            if (e) {
                if (this.enProgramme) {
                    this.Destroy();
                }
                Ecran.repaint();
                Ecran.nomProgramme(myPicaxe.Load());
                this.enProgramme = true;
                myPicaxe.set("X1", 0);
                myPicaxe.Reset();
                myPicaxe.Run(true);
                Ecran.progMaquette("_SB_RUN");
            }
        }
        catch (Exception evt) {
            Simul.Err(evt.getMessage(), true);
        }
    }

    public void setProg() {
        try {
            int e = myPicaxe.get("X1");
            if (e == 0) {
                myPicaxe.set("X1", 1);
            } else {
                myPicaxe.set("X1", 0);
            }
            this.setProg(e == 0);
        }
        catch (Exception e) {
            Simul.Err(e.getMessage(), true);
        }
    }

    public File Save(File f) {
        String nf = "";
        SelectionFichier myDialog = new SelectionFichier(f);
        myDialog.typeFichier("mqt");
        File fichMaq = myDialog.Save();
        if (fichMaq != null) {
            try {
                FileWriter fw = new FileWriter(fichMaq);
                String myInfo = "'" + this.Info.info.replace("\n", "\n'");
                fw.write(myInfo);
                fw.write("\r\n");
                fw.write("P=" + this.Info.processeur + "\r\n");
                fw.write("F=" + this.Info.fichFond + "\r\n");
                myPicaxe.Decrire(fw);
                fw.close();
                f = fichMaq;
            }
            catch (IOException e) {
                Simul.Err(e.getMessage(), true);
                f = null;
            }
        }
        return f;
    }

    public boolean Controle() {
        try {
            myPicaxe.set("X0", 0);
        }
        catch (Exception e) {
            Simul.Err(e.getMessage(), false);
        }
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.imgFond != null) {
            g.drawImage(this.imgFond, 0, 0, null);
        }
    }

    public boolean isPrograming() {
        return this.enProgramme;
    }

    public boolean isRunning() {
        return this.enExecution;
    }
}

