/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class Picaxe {
    public static final String[] Liste = new String[]{"P8M", "P20M", "P20M2", "P28X1"};
    protected Composant[] Connexions;
    protected int[] TypeConnexions;
    protected int[] Variables;
    private Interpreteur leInterpreteur;

    protected int Convert(String p) {
        return -1;
    }

    public String Load() {
        this.leInterpreteur = new Interpreteur(this);
        return this.leInterpreteur.infoProg();
    }

    public void Run(boolean run) {
        if (this.leInterpreteur == null) {
            return;
        }
        if (run) {
            this.leInterpreteur.start();
        } else {
            this.leInterpreteur.arret();
        }
    }

    public Composant Qui(String qui) {
        Composant c = null;
        try {
            int p = this.Convert(qui);
            if (p < 0) {
                throw new Exception("[" + qui + "] " + Simul.myLang.getString("_ERR4"));
            }
            if (this.Connexions[p] == null) {
                throw new Exception("[" + qui + "] " + Simul.myLang.getString("_ERR5"));
            }
            c = this.Connexions[p];
        }
        catch (Exception e) {
            Simul.Err(e.getMessage(), true);
        }
        return c;
    }

    public void Connect(String qui, Composant lui) {
        try {
            int p = this.Convert(qui);
            if (p < 0) {
                throw new Exception("[" + qui + "] " + Simul.myLang.getString("_ERR4"));
            }
            if (this.Connexions[p] != null) {
                throw new Exception("[" + qui + "] " + Simul.myLang.getString("_ERR6"));
            }
            this.Connexions[p] = lui;
        }
        catch (Exception e) {
            Simul.Err(e.getMessage(), true);
        }
    }

    public void Deconnect(String qui) {
        try {
            int p = this.Convert(qui);
            if (p < 0) {
                throw new Exception("[" + qui + "] " + Simul.myLang.getString("_ERR4"));
            }
            if (this.Connexions[p] == null) {
                throw new Exception("[" + qui + "] " + Simul.myLang.getString("_ERR5"));
            }
            this.Connexions[p] = null;
        }
        catch (Exception e) {
            Simul.Err(e.getMessage(), true);
        }
    }

    public int get(String qui) {
        int x = 0;
        try {
            int p = this.Convert(qui);
            if (p < 0) {
                throw new Exception("[" + qui + "] " + Simul.myLang.getString("_ERR4"));
            }
            if (this.Connexions[p] == null) {
                throw new Exception("[" + qui + "] " + Simul.myLang.getString("_ERR5"));
            }
            x = this.Connexions[p].get(qui);
        }
        catch (Exception e) {
            Simul.Err(e.getMessage(), false);
        }
        return x;
    }

    public void set(String qui, int v) {
        try {
            int p = this.Convert(qui);
            if (p < 0) {
                throw new Exception("[" + qui + "] " + Simul.myLang.getString("_ERR4"));
            }
            if (this.Connexions[p] == null) {
                throw new Exception("[" + qui + "] " + Simul.myLang.getString("_ERR4"));
            }
            this.Connexions[p].set(qui, v);
        }
        catch (Exception e) {
            Simul.Err(e.getMessage(), false);
        }
    }

    public int getReg(int r) {
        int x = 0;
        if (r < 0 || r >= this.Variables.length) {
            Simul.Err("[" + r + "] " + Simul.myLang.getString("_ERR7"), true);
        } else {
            x = this.Variables[r];
        }
        return x;
    }

    public void setReg(int r, int v) {
        if (r < 0 || r >= this.Variables.length) {
            Simul.Err("[" + r + "] " + Simul.myLang.getString("_ERR7"), true);
        }
        this.Variables[r] = v;
    }

    public void Hold() {
        Composant[] composantArray = this.Connexions;
        int n = this.Connexions.length;
        int n2 = 0;
        while (n2 < n) {
            Composant Connexion = composantArray[n2];
            if (Connexion != null) {
                Connexion.Hold();
            }
            ++n2;
        }
    }

    public void Reset() {
        Composant[] composantArray = this.Connexions;
        int n = this.Connexions.length;
        int n2 = 0;
        while (n2 < n) {
            Composant Connexion = composantArray[n2];
            if (Connexion != null) {
                Connexion.Reset();
            }
            ++n2;
        }
    }

    public void DecrireCat(FileWriter fw, String t) throws IOException {
        int c;
        int i = 0;
        do {
            if ((c = this.Convert(String.valueOf(t) + String.valueOf(i++))) < 0 || this.Connexions[c] == null || !this.Connexions[c].Decrire(fw, String.valueOf(t) + String.valueOf(i - 1))) continue;
            fw.write("\r\n");
        } while (c != -1);
    }

    public void Decrire(FileWriter fw) throws IOException {
        this.DecrireCat(fw, "X");
        this.DecrireCat(fw, "E");
        this.DecrireCat(fw, "A");
        this.DecrireCat(fw, "S");
        this.DecrireCat(fw, "C.");
        this.DecrireCat(fw, "B.");
        this.DecrireCat(fw, "A.");
        this.DecrireCat(fw, "D.");
    }

    public String[] Libre(String t) {
        int flag = 0;
        switch (t) {
            case "E": {
                flag = 1;
                break;
            }
            case "S": {
                flag = 2;
                break;
            }
            case "A": {
                flag = 4;
                break;
            }
            case "X": {
                flag = 8;
            }
        }
        ArrayList<String> Pins = new ArrayList<String>(1);
        int j = 0;
        while (j < this.Connexions.length) {
            if ((this.TypeConnexions[j] & flag) > 0 && this.Connexions[j] == null) {
                Pins.add(this.ReverseConvert(t, j));
            }
            ++j;
        }
        Pins.add(0, "");
        String[] p = new String[Pins.size()];
        int j2 = 0;
        while (j2 < Pins.size()) {
            p[j2] = (String)Pins.get(j2);
            ++j2;
        }
        return p;
    }

    public String[] Occupe(String t) {
        int flag = 0;
        switch (t) {
            case "E": {
                flag = 1;
            }
            case "S": {
                flag = 2;
            }
            case "A": {
                flag = 4;
            }
            case "X": {
                flag = 8;
            }
        }
        ArrayList<String> Pins = new ArrayList<String>(1);
        int j = 0;
        while (j < this.Connexions.length) {
            if ((this.TypeConnexions[j] & flag) == 1 && this.Connexions[j] != null) {
                Pins.add(this.ReverseConvert(t, j));
            }
            ++j;
        }
        Pins.add(0, "");
        String[] p = new String[Pins.size()];
        int j2 = 0;
        while (j2 < Pins.size()) {
            p[j2] = (String)Pins.get(j2);
            ++j2;
        }
        return p;
    }

    protected String ReverseConvert(String typ, int p) {
        return "";
    }
}

