/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SelectionFichier {
    private File repertoireCourant = null;
    private JFileChooser dialogue = null;

    public SelectionFichier(boolean home) {
        this.repertoireCourant = null;
        if (!home) {
            try {
                this.repertoireCourant = new File("./ressources/").getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.dialogue = new JFileChooser(this.repertoireCourant);
    }

    public SelectionFichier(File url) {
        this.dialogue = new JFileChooser(url);
    }

    public void typeFichier(String type) {
        FileNameExtensionFilter filter;
        switch (type) {
            case "bas": {
                this.dialogue.setDialogTitle(Simul.myLang.getString("_D1_T1"));
                filter = new FileNameExtensionFilter(Simul.myLang.getString("_D1_R1"), "bas");
                break;
            }
            case "img": {
                this.dialogue.setDialogTitle(Simul.myLang.getString("_D1_T4"));
                filter = new FileNameExtensionFilter(Simul.myLang.getString("_D1_R4"), "jpg", "png");
                break;
            }
            case "mqt": {
                this.dialogue.setDialogTitle(Simul.myLang.getString("_D1_T2"));
                filter = new FileNameExtensionFilter(Simul.myLang.getString("_D1_R2"), "mqt");
                break;
            }
            default: {
                this.dialogue.setDialogTitle(Simul.myLang.getString("_D1_T3"));
                filter = new FileNameExtensionFilter(Simul.myLang.getString("_T1_R3"), "*");
                this.dialogue.setAcceptAllFileFilterUsed(true);
            }
        }
        this.dialogue.setFileFilter(filter);
    }

    public File Open() {
        this.dialogue.setApproveButtonText(Simul.myLang.getString("_D1_C1"));
        if (this.dialogue.showOpenDialog(null) == 0) {
            return this.dialogue.getSelectedFile();
        }
        return null;
    }

    public File Save() {
        this.dialogue.showSaveDialog(null);
        return this.dialogue.getSelectedFile();
    }
}

