/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Simul
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final String _ICON = "Simul.png";
    private static final String _LANG = "Lang/LangSimul";
    private final int _WIDTH = 800;
    private final int _HIGH = 680;
    public static ResourceBundle myLang;
    private JMenuBar menuBar = null;
    private static JLabel sbErr;
    private final JLabel sbMaq;
    private final JLabel sbProg;
    private final JLabel sbEtat;
    public TitreKeyListener ptTelec = null;
    private static Maquette myMaquette;
    public File pathRef = null;
    private boolean enModif = false;
    private boolean enEdition = false;

    static {
        myMaquette = null;
    }

    public static void main(String[] args) {
        Locale curentLocale = Locale.getDefault();
        myLang = ResourceBundle.getBundle(_LANG, curentLocale);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Simul simul = new Simul();
                }
                catch (Exception e) {
                    Simul.Err(String.valueOf(e.toString()) + "/n" + myLang.getString("_ERR0"), false);
                }
            }
        });
    }

    public Simul() {
        this.setType(Window.Type.NORMAL);
        this.setBounds(100, 50, 800, 680);
        this.setResizable(false);
        this.setTitle(myLang.getString("_TITRE"));
        Image img = Toolkit.getDefaultToolkit().getImage("Simul.png");
        this.setIconImage(img);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        JPanel sp = new JPanel();
        sp.setLayout(new FlowLayout(0));
        this.sbMaq = new JLabel(myLang.getString("_SB_MAQ"));
        this.sbMaq.setPreferredSize(new Dimension(200, 20));
        this.sbMaq.setBorder(BorderFactory.createBevelBorder(1));
        sp.add(this.sbMaq);
        this.sbProg = new JLabel(myLang.getString("_SB_PROG"));
        this.sbProg.setPreferredSize(new Dimension(200, 20));
        this.sbProg.setBorder(BorderFactory.createBevelBorder(1));
        sp.add(this.sbProg);
        this.sbEtat = new JLabel("");
        this.sbEtat.setPreferredSize(new Dimension(50, 20));
        this.sbEtat.setBorder(BorderFactory.createBevelBorder(1));
        sp.add(this.sbEtat);
        sbErr = new JLabel("");
        sbErr.setFont(new Font("Tahoma", 0, 9));
        sbErr.setPreferredSize(new Dimension(310, 20));
        sbErr.setBorder(BorderFactory.createBevelBorder(1));
        sp.add(sbErr);
        this.getContentPane().add("South", sp);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu mnFichiers = new JMenu(myLang.getString("_MENU_FICHIERS"));
        mnFichiers.setMnemonic(70);
        this.menuBar.add(mnFichiers);
        JMenuItem mntmNouveau = new JMenuItem(myLang.getString("_MENU_CREER"), 67);
        mntmNouveau.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.offMaquette();
                Simul.this.newMaquette();
            }
        });
        mnFichiers.add(mntmNouveau);
        JMenuItem mntmOuvrir = new JMenuItem(myLang.getString("_MENU_OUVRIR"), 79);
        mntmOuvrir.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mntmOuvrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.offMaquette();
                Simul.this.openMaquette();
            }
        });
        mnFichiers.add(mntmOuvrir);
        JMenuItem mntmEnregistrer = new JMenuItem(myLang.getString("_MENU_ENREGISTRER"), 69);
        mntmEnregistrer.setEnabled(false);
        mntmEnregistrer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.saveMaquette(true);
            }
        });
        mnFichiers.add(mntmEnregistrer);
        JMenuItem mntmFermer = new JMenuItem(myLang.getString("_MENU_FERMER"), 70);
        mntmFermer.setEnabled(false);
        mntmFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.offMaquette();
            }
        });
        mnFichiers.add(mntmFermer);
        mnFichiers.addSeparator();
        JMenuItem mntmQuitter = new JMenuItem(myLang.getString("_MENU_QUITTER"), 81);
        mntmQuitter.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        mntmQuitter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.quitMaquette();
            }
        });
        mnFichiers.add(mntmQuitter);
        JMenu mnSimulation = new JMenu(myLang.getString("_MENU_SIMULATION"));
        mnSimulation.setEnabled(false);
        this.menuBar.add((Component)mnSimulation);
        JCheckBoxMenuItem mntmLancer = new JCheckBoxMenuItem(myLang.getString("_MENU_ALIMENTER"), false);
        mntmLancer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                myMaquette.setAlim();
            }
        });
        ((Container)mnSimulation).add(mntmLancer);
        JCheckBoxMenuItem mntmCharger = new JCheckBoxMenuItem(myLang.getString("_MENU_PROGRAMMER"), false);
        mntmCharger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                myMaquette.setProg();
            }
        });
        ((Container)mnSimulation).add(mntmCharger);
        JMenu mnEdition = new JMenu(myLang.getString("_MENU_EDITION"));
        mnEdition.setEnabled(false);
        this.menuBar.add((Component)mnEdition);
        JCheckBoxMenuItem mntmModifier = new JCheckBoxMenuItem(myLang.getString("_MENU_MODIFIER"), false);
        mntmModifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.modifMaquette();
            }
        });
        ((Container)mnEdition).add(mntmModifier);
        JMenuItem mntmAjouter = new JMenuItem(myLang.getString("_MENU_AJOUTER"));
        mntmAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Simul.this.ajoutMaquette();
            }
        });
        ((Container)mnEdition).add(mntmAjouter);
        JMenu mnAide = new JMenu(myLang.getString("_MENU_AIDE"));
        this.menuBar.add((Component)mnAide);
        JMenuItem mntmInfo = new JMenuItem(myLang.getString("_MENU_INFO"));
        mntmInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String zInfo = String.valueOf(myLang.getString("_TITRE")) + "\n\n";
                zInfo = String.valueOf(zInfo) + myLang.getString("_VERSION") + "\n" + myLang.getString("_AUTEUR") + "\n";
                zInfo = String.valueOf(zInfo) + myLang.getString("_LICENCE") + "\n\n";
                zInfo = String.valueOf(zInfo) + myLang.getString("_SB_INFO");
                JOptionPane.showMessageDialog(null, zInfo, myLang.getString("_DIALOG_INFORMATIONS"), 1);
            }
        });
        ((Container)mnAide).add(mntmInfo);
        this.ptTelec = new TitreKeyListener();
        this.addKeyListener(this.ptTelec);
    }

    private void newMaquette() {
        sbErr.setText("");
        myMaquette = new Maquette(this);
        if (!myMaquette.newMaquette()) {
            myMaquette = null;
            return;
        }
        this.getContentPane().add("Center", myMaquette);
        this.sbMaq.setText(String.valueOf(myLang.getString("_SB_MAQ")) + "Sans_nom.mqt");
        this.enModif = true;
        this.enEdition = true;
        this.sbEtat.setText(myLang.getString("_SB_EDIT"));
        this.menuBar.getMenu(0).getItem(2).setEnabled(true);
        this.menuBar.getMenu(0).getItem(3).setEnabled(true);
        this.menuBar.getMenu(1).setEnabled(false);
        this.menuBar.getMenu(2).setEnabled(true);
        this.menuBar.getMenu(2).getItem(0).setEnabled(true);
        this.menuBar.getMenu(2).getItem(1).setEnabled(true);
        this.repaint();
    }

    private void openMaquette() {
        sbErr.setText("");
        myMaquette = new Maquette(this);
        this.pathRef = myMaquette.initMaquette(this.pathRef);
        if (this.pathRef == null) {
            myMaquette = null;
            return;
        }
        this.getContentPane().add("Center", myMaquette);
        this.sbMaq.setText(String.valueOf(myLang.getString("_SB_MAQ")) + this.pathRef.getName());
        this.enModif = false;
        this.enEdition = false;
        this.sbEtat.setText("");
        this.menuBar.getMenu(0).getItem(2).setEnabled(true);
        this.menuBar.getMenu(0).getItem(3).setEnabled(true);
        this.menuBar.getMenu(1).setEnabled(true);
        this.menuBar.getMenu(1).getItem(0).setEnabled(true);
        this.menuBar.getMenu(1).getItem(1).setEnabled(false);
        this.menuBar.getMenu(2).setEnabled(true);
        this.menuBar.getMenu(2).getItem(0).setEnabled(true);
        this.menuBar.getMenu(2).getItem(1).setEnabled(false);
        this.repaint();
    }

    private void saveMaquette(boolean force) {
        int reponse;
        if (!this.enModif && !force) {
            return;
        }
        if (this.enModif && !force && (reponse = JOptionPane.showConfirmDialog(this, myLang.getString("_DIALOG_Q1"), myLang.getString("_DIALOG_CONFIRMATION"), 0, 3)) == 1) {
            return;
        }
        this.pathRef = myMaquette.Save(this.pathRef);
        if (this.pathRef != null) {
            this.enModif = false;
            this.sbMaq.setText(this.pathRef.getName());
            sbErr.setText("");
        }
    }

    private void offMaquette() {
        sbErr.setText("");
        if (myMaquette != null) {
            this.saveMaquette(false);
            this.remove(myMaquette);
            myMaquette.Destroy();
            myMaquette = null;
        }
        this.sbMaq.setText(myLang.getString("_SB_MAQ"));
        this.enModif = false;
        this.enEdition = false;
        this.sbEtat.setText("");
        this.menuBar.getMenu(1).getItem(0).setSelected(false);
        this.menuBar.getMenu(1).getItem(1).setSelected(false);
        this.menuBar.getMenu(0).getItem(2).setEnabled(false);
        this.menuBar.getMenu(0).getItem(3).setEnabled(false);
        this.menuBar.getMenu(1).setEnabled(false);
        this.menuBar.getMenu(2).setEnabled(false);
        this.repaint();
    }

    private void quitMaquette() {
        this.offMaquette();
        System.exit(0);
    }

    public void alimMaquette(boolean e) {
        if (e) {
            this.sbEtat.setText(myLang.getString("_SB_ON"));
            this.menuBar.getMenu(1).getItem(0).setSelected(true);
            this.menuBar.getMenu(2).setEnabled(false);
            this.menuBar.getMenu(1).getItem(1).setEnabled(true);
        } else {
            this.sbEtat.setText("");
            this.menuBar.getMenu(1).getItem(0).setSelected(false);
            this.menuBar.getMenu(2).setEnabled(true);
            this.menuBar.getMenu(1).getItem(1).setEnabled(false);
        }
    }

    public void progMaquette(String e) {
        if (e.equals("_SB_ON")) {
            this.menuBar.getMenu(1).getItem(1).setSelected(false);
        } else {
            this.menuBar.getMenu(1).getItem(1).setSelected(true);
        }
        this.sbEtat.setText(myLang.getString(e));
    }

    private void modifMaquette() {
        if (!this.enEdition) {
            this.enEdition = true;
            this.sbEtat.setText(myLang.getString("_SB_EDIT"));
            this.menuBar.getMenu(2).getItem(0).setSelected(true);
            this.menuBar.getMenu(1).setEnabled(false);
            this.menuBar.getMenu(2).getItem(1).setEnabled(true);
        } else {
            if (!myMaquette.Controle()) {
                return;
            }
            this.saveMaquette(false);
            this.enEdition = false;
            this.sbEtat.setText("");
            this.menuBar.getMenu(2).getItem(0).setSelected(false);
            this.menuBar.getMenu(1).setEnabled(true);
            this.menuBar.getMenu(2).getItem(1).setEnabled(false);
        }
    }

    private void ajoutMaquette() {
        if (this.enEdition) {
            myMaquette.Composant();
            this.enModif = true;
        }
    }

    public void nomProgramme(String nom) {
        this.sbProg.setText(String.valueOf(myLang.getString("_SB_PROG")) + nom);
    }

    public boolean isModif() {
        return this.enEdition;
    }

    public void setModif() {
        this.enModif = true;
    }

    public static void Err(String mesg, boolean warning) {
        if (!warning) {
            myMaquette.setAlim(false);
            JOptionPane.showMessageDialog(null, mesg, myLang.getString("_DIALOG_ERREUR"), 0);
        } else {
            JOptionPane.showMessageDialog(null, mesg, myLang.getString("_DIALOG_INFORMATIONS"), 2);
        }
        sbErr.setText(mesg);
    }
}

